/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.mediaplayer;

import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.icons.IconFactory;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.ui.elements.UITooltip;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Slider;
import javafx.scene.layout.HBox;
import javafx.scene.media.MediaView;

public final class VolumeSlider {
    @Inject
    private IconFactory iconFactory;
    private Slider volume;
    private InvalidationListener volumenListener;
    private final MediaView mediaView;

    public VolumeSlider(MediaView mediaView) {
        Container.inject(this);
        this.mediaView = mediaView;
    }

    public HBox create() {
        HBox root = new HBox();
        root.setAlignment(Pos.BASELINE_CENTER);
        this.volume = new Slider();
        this.volume.setPrefWidth(100.0);
        this.volume.setMinWidth(30.0);
        this.volume.setPrefHeight(32.0);
        this.volume.setValue(100.0);
        root.getChildren().addAll((Object[])new Node[]{this.iconFactory.create(DefaultIcons.PlayerVolume), this.volume});
        new UITooltip("(+/-)").install((Node)root);
        return root;
    }

    public void reset() {
        this.volumenListener = new InvalidationListener(){

            public void invalidated(Observable ov) {
                if (VolumeSlider.this.volume.isPressed()) {
                    VolumeSlider.this.mediaView.getMediaPlayer().setVolume(VolumeSlider.this.volume.getValue() / 100.0);
                }
            }
        };
        this.volume.valueProperty().addListener(this.volumenListener);
    }

    public void addVolume() {
        this.volume.setValue(this.volume.getValue() + 1.0);
        this.mediaView.getMediaPlayer().setVolume(this.volume.getValue() / 100.0);
    }

    public void subVolume() {
        this.volume.setValue(this.volume.getValue() - 1.0);
        this.mediaView.getMediaPlayer().setVolume(this.volume.getValue() / 100.0);
    }

    public void stop() {
        this.volume.valueProperty().removeListener(this.volumenListener);
    }

    public void setValue(Double value) {
        this.volume.setValue(value.doubleValue());
        this.mediaView.getMediaPlayer().setVolume(this.volume.getValue() / 100.0);
    }

    public Double getValue() {
        return this.volume.getValue();
    }
}

