/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.mediaplayer;

import de.mallongigi.mediaplayer.MediaPlayerKeyListener;
import de.mallongigi.mediaplayer.VolumeSlider;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.views.ApplicationViewNames;
import de.mallongigi.views.ApplicationViews;
import de.mallongigi.views.ApplicationViewsModel;
import javafx.event.EventHandler;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.media.MediaPlayer;
import javafx.util.Duration;

public final class MediaplayerKeyHandler
implements EventHandler<KeyEvent> {
    @Inject
    private ApplicationViews views;
    @Inject
    private ApplicationViewsModel viewModel;
    private final MediaPlayerKeyListener mediaPlayerKeyListener;
    private MediaPlayer player;
    private final VolumeSlider volumeSlider;

    public MediaplayerKeyHandler(MediaPlayer player, VolumeSlider volumeSlider, MediaPlayerKeyListener listener) {
        Container.inject(this);
        this.player = player;
        this.volumeSlider = volumeSlider;
        this.mediaPlayerKeyListener = listener;
        this.views.addEventFilter(KeyEvent.KEY_PRESSED, this);
    }

    public void setPlayer(MediaPlayer player) {
        this.player = player;
    }

    public void removePlayer() {
        this.player = null;
    }

    public void handle(KeyEvent event) {
        if (this.player == null || this.viewModel.selectedViewProperty().get() != ApplicationViewNames.Mediaplayer) {
            return;
        }
        KeyCode code = event.getCode();
        switch (code) {
            case PLUS: {
                this.volumeSlider.addVolume();
                break;
            }
            case MINUS: {
                this.volumeSlider.subVolume();
                break;
            }
            case RIGHT: {
                this.player.seek(this.player.getCurrentTime().add(new Duration(10000.0)));
                event.consume();
                break;
            }
            case LEFT: {
                if (this.player.getStartTime().toMillis() > 0.0) {
                    this.player.setStartTime(new Duration(0.0));
                }
                this.player.seek(this.player.getCurrentTime().subtract(new Duration(10000.0)));
                event.consume();
                break;
            }
            case SPACE: {
                if (this.player.getStatus().equals((Object)MediaPlayer.Status.PLAYING)) {
                    this.player.pause();
                } else {
                    this.player.play();
                }
                event.consume();
                break;
            }
            case ESCAPE: {
                this.mediaPlayerKeyListener.stop();
                event.consume();
                break;
            }
        }
    }
}

