/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.mediaplayer;

import de.mallongigi.file.FileUtil;
import de.mallongigi.file.PodcastFileExtension;
import de.mallongigi.mediaplayer.VideoMediaPlayer;
import de.mallongigi.mediaplayer.audio.AudioMediaPlayer;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.views.ApplicationViewNames;
import de.mallongigi.views.ApplicationViewsModel;
import javafx.scene.Node;
import javafx.scene.control.Tab;

public final class MediaPlayerProxy {
    private final Tab mediaPlayerTab;
    private AudioMediaPlayer audioMediaPlayer;
    private VideoMediaPlayer videoMediaPlayer;
    @Inject
    private ApplicationViewsModel viewsModel;

    public MediaPlayerProxy(Tab mediaPlayerTab) {
        this.mediaPlayerTab = mediaPlayerTab;
        Container.inject(this);
    }

    public void init() {
        this.audioMediaPlayer = new AudioMediaPlayer();
        this.videoMediaPlayer = new VideoMediaPlayer();
    }

    public void setEpisode(PodcastEpisodeModel episode) throws Exception {
        this.audioMediaPlayer.stop();
        this.videoMediaPlayer.stop();
        if (this.isAudio(episode)) {
            this.mediaPlayerTab.setContent((Node)this.audioMediaPlayer.getRoot());
            this.audioMediaPlayer.setPodcastEpisode(episode);
            this.audioMediaPlayer.play();
        } else {
            this.mediaPlayerTab.setContent((Node)this.videoMediaPlayer.getRoot());
            this.videoMediaPlayer.setPodcastEpisode(episode);
            this.videoMediaPlayer.play();
        }
        this.viewsModel.setView(ApplicationViewNames.Mediaplayer);
    }

    public boolean isAudio(PodcastEpisodeModel episode) {
        String format = episode.getMediaType();
        if (format != null && format.indexOf("audio") != -1) {
            return true;
        }
        String type = FileUtil.getFileFormat(episode.getUrl());
        if (type == null) {
            return false;
        }
        for (String f : PodcastFileExtension.audioList) {
            if (!type.equals(f)) continue;
            return true;
        }
        return false;
    }

    public boolean isPlaying(PodcastEpisodeModel item) {
        return this.audioMediaPlayer.isPlaying(item) || this.videoMediaPlayer.isPlaying(item);
    }
}

