/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.http.feed.rss;

import de.mallongigi.http.HttpParameters;
import de.mallongigi.http.feed.PodcastChannelParser;
import de.mallongigi.http.feed.PodcastFeedConnectionConfig;
import de.mallongigi.http.feed.rss.RSSFeedParser;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.time.Duration;

public final class RSSFeedPodcastConnectionConfig
implements PodcastFeedConnectionConfig {
    @Override
    public PodcastChannelParser getPodcastChannelParser(boolean markAsNew) {
        return new RSSFeedParser(markAsNew);
    }

    @Override
    public HttpRequest createHttpRequest(PodcastChannelModel model) {
        String[] acceptContentTypes = new String[]{"application/rss+xml", "application/xml"};
        String cashHash = model.getCachHash();
        String url = model.getPodcastFeedUrl();
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(url)).header(HttpParameters.USER_AGENT.value(), "Mallongigi Podcatcher").header(HttpParameters.ACCEPT_ENCODING.value(), "gzip, deflate").version(HttpClient.Version.HTTP_1_1).GET().timeout(Duration.ofMinutes(1L));
        if (cashHash != null && cashHash.length() > 0) {
            requestBuilder.header(HttpParameters.IF_NONE_MATCH.value(), cashHash);
        }
        for (String p : acceptContentTypes) {
            requestBuilder.header(HttpParameters.ACCEPT_CONTENT_TYPE.value(), p);
        }
        return requestBuilder.build();
    }
}

