/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.http.feed.rss;

import de.mallongigi.http.feed.FeedContent;
import de.mallongigi.http.feed.PodcastChannelParser;
import de.mallongigi.http.feed.rss.RSSFeedElements;
import de.mallongigi.mediaplayer.transcription.TranscriptionTypes;
import de.mallongigi.mediaplayer.transcription.TranscriptionsLocations;
import de.mallongigi.podcast.channel.model.PodcastChannelFeedType;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.episode.model.Chapter;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.time.DateTimeConverter;
import de.mallongigi.time.PodloveTimeConverter;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

final class RSSFeedParser
implements PodcastChannelParser {
    private static final Logger LOG = Logger.getLogger(RSSFeedParser.class.getName());
    private final boolean markAsNew;
    @Inject
    private DateTimeConverter dateTimeConverter;
    @Inject
    private PodloveTimeConverter chapterTimeConverter;

    public RSSFeedParser(boolean markAsNew) {
        this.markAsNew = markAsNew;
        Container.inject(this);
    }

    @Override
    public PodcastChannelModel parse(FeedContent connection) throws Exception {
        try {
            PodcastChannelModel pcm = new PodcastChannelModel();
            pcm.setFeedType(PodcastChannelFeedType.RSS);
            pcm.setPodcastFeedUrl(connection.getURL());
            connection.connect();
            pcm.setCachHash(connection.getCashHash());
            pcm.setErrorMessage(connection.getConnectionError());
            if (!connection.hasContent()) {
                return pcm;
            }
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isCoalescing", true);
            XMLEventReader reader = factory.createXMLEventReader(new StringReader(connection.getContent()));
            while (reader.hasNext()) {
                RSSFeedElements tag;
                XMLEvent nextEvent = reader.nextEvent();
                if (!nextEvent.isStartElement() || (tag = this.translate(nextEvent.asStartElement())) == null || tag != RSSFeedElements.channel) continue;
                this.parseChannel(pcm, reader);
            }
            if (connection.getPermanentRedirectUrl() != null) {
                pcm.setPodcastFeedUrl(connection.getPermanentRedirectUrl());
            }
            return pcm;
        }
        catch (Exception e) {
            LOG.log(Level.INFO, e.getMessage(), e);
            throw e;
        }
    }

    private PodcastEpisodeModel parseEpisode(XMLEventReader reader, PodcastChannelModel pcm) throws XMLStreamException {
        ContextTypes context = ContextTypes.NONE;
        PodcastEpisodeModel result = new PodcastEpisodeModel();
        result.getState().setNew(this.markAsNew);
        while (reader.hasNext()) {
            EndElement endElement;
            XMLEvent nextEvent = reader.nextEvent();
            if (nextEvent.isStartElement()) {
                StartElement startElement = nextEvent.asStartElement();
                RSSFeedElements tag = this.translate(startElement);
                if (tag == null) continue;
                block3 : switch (tag) {
                    case pubdate: {
                        String value;
                        try {
                            value = this.getText(reader);
                            Date date = this.dateTimeConverter.convert(value);
                            result.setDate(date);
                        }
                        catch (Exception e) {
                            LOG.info(e.getMessage());
                        }
                        break;
                    }
                    case description: {
                        result.setDescription(this.getText(reader));
                        break;
                    }
                    case itunes_duration: {
                        String value = this.getText(reader);
                        if (value.indexOf(":") == -1) {
                            try {
                                result.setDuration(BigDecimal.valueOf(Integer.valueOf(value).intValue()));
                            }
                            catch (Exception e) {
                                result.setDuration(value);
                            }
                            break;
                        }
                        try {
                            if (Long.parseLong(value.replace(":", "")) == 0L) {
                                result.setDuration("");
                                break;
                            }
                            result.setDuration(value);
                        }
                        catch (Exception e) {
                            LOG.log(Level.SEVERE, e.getMessage(), e);
                            result.setDuration(value);
                        }
                        break;
                    }
                    case enclosure: {
                        Attribute type;
                        Attribute length;
                        Attribute url = startElement.getAttributeByName(new QName("url"));
                        if (url != null) {
                            result.setUrl(url.getValue());
                        }
                        if ((length = startElement.getAttributeByName(new QName("length"))) != null) {
                            result.setLength(length.getValue());
                        }
                        if ((type = startElement.getAttributeByName(new QName("type"))) == null) break;
                        result.setMediaType(type.getValue());
                        break;
                    }
                    case guid: {
                        String id = this.getText(reader);
                        if (id.isBlank()) {
                            Attribute guid = startElement.getAttributeByName(new QName("guid"));
                            if (guid != null) {
                                result.setId(guid.getValue());
                                break;
                            }
                            guid = startElement.getAttributeByName(new QName("url"));
                            if (guid == null) break;
                            result.setId(guid.getValue());
                            break;
                        }
                        result.setId(id);
                        break;
                    }
                    case image: 
                    case itunes_image: {
                        context = ContextTypes.IMAGE;
                    }
                    case url: {
                        if (context != ContextTypes.IMAGE || result.getImageURL() != null && !result.getImageURL().isBlank()) break;
                        result.setImageURL(this.getImageUrl(reader, startElement, context));
                        break;
                    }
                    case itunes_subtitle: {
                        result.setSubtitle(this.getText(reader));
                        break;
                    }
                    case title: {
                        result.setTitle(this.getText(reader));
                        break;
                    }
                    case link: {
                        result.setLink(this.getText(reader));
                        break;
                    }
                    case content_encoded: {
                        result.setShownotes(this.getText(reader));
                        break;
                    }
                    case psc_chapter: {
                        Long time;
                        Attribute title = startElement.getAttributeByName(new QName("title"));
                        Attribute start = startElement.getAttributeByName(new QName("start"));
                        Attribute image = startElement.getAttributeByName(new QName("image"));
                        Attribute link = startElement.getAttributeByName(new QName("href"));
                        if (start == null || (time = this.chapterTimeConverter.convert(start.getValue())) == null) break;
                        Chapter chapter = new Chapter(time);
                        if (title != null) {
                            chapter.setTitle(title.getValue());
                        }
                        if (image != null) {
                            chapter.setImageURL(image.getValue());
                        }
                        if (link != null) {
                            chapter.setLink(link.getValue());
                        }
                        result.addChapter(chapter);
                        break;
                    }
                    case podcast_transcript: {
                        Attribute transcriptUrl = startElement.getAttributeByName(new QName("url"));
                        Attribute transcriptTyp = startElement.getAttributeByName(new QName("type"));
                        switch (transcriptTyp.getValue()) {
                            case "application/json": {
                                result.addTranscription(new TranscriptionsLocations(TranscriptionTypes.JSON, transcriptUrl.getValue()));
                                break block3;
                            }
                            case "text/vtt": {
                                result.addTranscription(new TranscriptionsLocations(TranscriptionTypes.VTT, transcriptUrl.getValue()));
                            }
                        }
                    }
                }
            }
            if (!nextEvent.isEndElement() || !(endElement = nextEvent.asEndElement()).getName().getLocalPart().equalsIgnoreCase("item")) continue;
            if (result.getUrl() == null) {
                return null;
            }
            if (result.getId() == null) {
                result.setId(result.getUrl());
            }
            return result;
        }
        return null;
    }

    private void parseChannel(PodcastChannelModel pcm, XMLEventReader reader) throws XMLStreamException {
        ContextTypes context = ContextTypes.NONE;
        while (reader.hasNext()) {
            StartElement startElement;
            RSSFeedElements tag;
            XMLEvent nextEvent = reader.nextEvent();
            if (!nextEvent.isStartElement() || (tag = this.translate(startElement = nextEvent.asStartElement())) == null) continue;
            switch (tag) {
                case title: {
                    if (!pcm.getTitle().isBlank()) break;
                    pcm.setTitle(this.getText(reader));
                    break;
                }
                case description: {
                    pcm.setDescription(this.getText(reader));
                    break;
                }
                case link: {
                    if (!pcm.getHomepage().isBlank()) break;
                    pcm.setHomepage(this.getText(reader));
                    break;
                }
                case image: 
                case itunes_image: {
                    context = ContextTypes.IMAGE;
                }
                case url: {
                    if (context != ContextTypes.IMAGE || pcm.getImageURL() != null && !pcm.getImageURL().isBlank()) break;
                    pcm.setImageURL(this.getImageUrl(reader, startElement, context));
                    break;
                }
                case alternate: {
                    Attribute rel = startElement.getAttributeByName(new QName("rel"));
                    if (rel == null || !rel.getValue().equalsIgnoreCase("alternate")) break;
                    Attribute titleAttribute = startElement.getAttributeByName(new QName("title"));
                    Attribute hrefAttribute = startElement.getAttributeByName(new QName("href"));
                    if (titleAttribute == null || hrefAttribute == null) break;
                    pcm.addAlternativ(titleAttribute.getValue(), hrefAttribute.getValue());
                    break;
                }
                case item: {
                    PodcastEpisodeModel item = this.parseEpisode(reader, pcm);
                    if (item == null) break;
                    item.setChannel(pcm);
                    pcm.add(item);
                    break;
                }
            }
        }
    }

    private String getImageUrl(XMLEventReader reader, StartElement startElement, ContextTypes context) {
        Attribute href = startElement.getAttributeByName(new QName("href"));
        if (href != null) {
            return href.getValue();
        }
        try {
            return reader.getElementText();
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getText(XMLEventReader reader) {
        try {
            String text = reader.getElementText();
            return text;
        }
        catch (Exception e) {
            LOG.log(Level.INFO, e.getMessage(), e);
            return "";
        }
    }

    private RSSFeedElements translate(StartElement startElement) {
        if (startElement == null) {
            return null;
        }
        QName tag = startElement.getName();
        String name = tag.getLocalPart().toLowerCase();
        String namespace = tag.getNamespaceURI();
        for (RSSFeedElements e : RSSFeedElements.values()) {
            if (!name.equals(e.getTag()) || !namespace.equals(e.getNamespace())) continue;
            return e;
        }
        return null;
    }

    private static enum ContextTypes {
        NONE,
        IMAGE;

    }
}

