/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.http.feed.ard;

import de.mallongigi.http.HttpParameters;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ARDAudiothekConverter {
    private static final Logger LOG = Logger.getLogger(ARDAudiothekConverter.class.getName());

    public String convert(String url) {
        try {
            HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build();
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(new URI(url)).header(HttpParameters.USER_AGENT.value(), "Mallongigi Podcatcher").version(HttpClient.Version.HTTP_1_1).GET().timeout(Duration.ofMinutes(1L));
            HttpRequest request = requestBuilder.build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                return null;
            }
            String body = response.body();
            int start = body.indexOf("\"programSet\":{\"id\":");
            if (start == -1) {
                return null;
            }
            int end = body.indexOf("\",", start);
            if (end == -1) {
                return null;
            }
            String result = response.body().substring(start + 20, end);
            result = result.replaceAll("\\W", "");
            String apiCall = "https://api.ardaudiothek.de/graphql/programsets/" + result;
            return apiCall;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }
}

