/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.http.feed;

import de.mallongigi.http.ByteOrderMarkets;
import de.mallongigi.http.HttpParameters;
import de.mallongigi.http.HttpResponseHeader;
import de.mallongigi.http.feed.FeedContent;
import de.mallongigi.http.feed.PodcastFeedConnectionConfig;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.resource.language.LanguageResource;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.zip.GZIPInputStream;

public final class FeedURLConnector
implements FeedContent {
    @Inject
    private LanguageResource languageResource;
    private String cashHash;
    private final PodcastChannelModel model;
    private String content;
    private String connectionError;
    private String permanentRedirectUrl;
    private final PodcastFeedConnectionConfig config;

    public FeedURLConnector(PodcastChannelModel model, PodcastFeedConnectionConfig config) throws IOException {
        this.model = model;
        this.config = config;
        Container.inject(this);
    }

    @Override
    public void connect() throws Exception {
        this.content = this.readContent();
    }

    private String readContent() throws Exception {
        HttpRequest request;
        String url = this.getURL();
        String cashHash = this.model.getCachHash();
        if (!url.toLowerCase().startsWith("http")) {
            return null;
        }
        HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build();
        HttpResponse<InputStream> response = client.send(request = this.config.createHttpRequest(this.model), HttpResponse.BodyHandlers.ofInputStream());
        if (response.statusCode() == 304) {
            this.cashHash = this.model.getCachHash();
            return null;
        }
        if (response.statusCode() >= 400) {
            this.connectionError = response.statusCode() + " - " + this.languageResource.messageForKey(LanguageKeys.errorMessageRefreshFeed);
            return null;
        }
        HttpResponseHeader headers = new HttpResponseHeader(response.headers());
        this.cashHash = headers.getNewETag(cashHash);
        String contentType = response.headers().firstValue(HttpParameters.CONTENT_TYPE.value()).get();
        if (contentType != null && contentType.startsWith("text/html")) {
            this.connectionError = "Can't parse HTML Format Response.";
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        String encoding = headers.getContentEncoding();
        String charset = headers.getCharset();
        if (encoding != null && encoding.equals("gzip")) {
            try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(response.body()), charset));){
                if (charset.toLowerCase().equals("utf-8")) {
                    this.readUTF8(buffer, in);
                }
                this.read(buffer, in);
            }
        } else {
            try (BufferedReader in = new BufferedReader(new InputStreamReader(response.body(), charset));){
                if (charset.toLowerCase().equals("utf-8")) {
                    this.readUTF8(buffer, in);
                } else {
                    this.read(buffer, in);
                }
            }
        }
        if (!response.uri().equals(request.uri()) && response.statusCode() == 308) {
            this.permanentRedirectUrl = response.uri().toString();
        }
        return buffer.toString();
    }

    private void readUTF8(StringBuffer buffer, BufferedReader in) throws IOException {
        String line;
        boolean firstLine = true;
        while ((line = in.readLine()) != null) {
            if (firstLine) {
                if (line.startsWith(ByteOrderMarkets.UTF8_BOM.value())) {
                    line = line.substring(1);
                }
                firstLine = false;
            }
            buffer.append(line + "\n");
        }
    }

    private void read(StringBuffer buffer, BufferedReader in) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            buffer.append(line + "\n");
        }
    }

    @Override
    public String getCashHash() {
        return this.cashHash;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public boolean hasContent() {
        return this.content != null;
    }

    @Override
    public String getConnectionError() {
        return this.connectionError;
    }

    @Override
    public String getPermanentRedirectUrl() {
        return this.permanentRedirectUrl;
    }

    @Override
    public String getURL() {
        return this.model.getPodcastFeedUrl();
    }
}

