/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.http;

import de.mallongigi.http.HttpParameters;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.toolbar.ApplicationToolbarModel;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class VersionCheck
extends Thread {
    private static final Logger LOG = Logger.getLogger(VersionCheck.class.getName());
    @Inject
    private ApplicationSettings settings;
    @Inject
    private ApplicationToolbarModel toolbarModel;

    public VersionCheck() {
        Container.inject(this);
    }

    @Override
    public void run() {
        try {
            String version = ApplicationSettings.getVersion();
            LOG.info("Current Mallongigi Version is " + version);
            HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).connectTimeout(Duration.ofMinutes(1L)).build();
            HttpRequest request = HttpRequest.newBuilder().GET().uri(URI.create("http://www.mallongigi.de/update/" + this.settings.getRegistryNumber() + "_" + version + ".html")).setHeader(HttpParameters.USER_AGENT.value(), "Mallongigi").build();
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            String buffer = response.body();
            new ApplicationSettings();
            this.toolbarModel.setNewMallongigiVersionAvailable(!buffer.trim().equals(ApplicationSettings.getVersion()));
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Cant check new Mallongigi Version", e);
            return;
        }
    }
}

