/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.http;

import de.mallongigi.http.HttpParameters;
import java.net.http.HttpHeaders;
import java.util.Iterator;
import java.util.List;

public final class HttpResponseHeader {
    private final HttpHeaders headers;

    public HttpResponseHeader(HttpHeaders headers) {
        this.headers = headers;
    }

    public String getNewETag(String currentETag) {
        List<String> list = this.headers.allValues(HttpParameters.ETAG.value());
        if (list == null || list.isEmpty()) {
            return "";
        }
        Iterator<String> iterator = list.iterator();
        if (iterator.hasNext()) {
            String v = iterator.next();
            return v;
        }
        return "";
    }

    public String getContentEncoding() {
        List<String> list = this.headers.allValues(HttpParameters.CONTENT_ENCODING.value());
        if (list == null || list.isEmpty()) {
            return null;
        }
        Iterator<String> iterator = list.iterator();
        if (iterator.hasNext()) {
            String v = iterator.next();
            return v;
        }
        return null;
    }

    public String getCharset() {
        List<String> list = this.headers.allValues(HttpParameters.CONTENT_ENCODING.value());
        if (list == null || list.isEmpty()) {
            return "UTF-8";
        }
        for (String v : list) {
            String[] strings;
            for (String s : strings = v.split(";")) {
                if (!(s = s.trim()).startsWith("charset=")) continue;
                return s.substring(8).replaceAll("\"", "").replaceAll("'", "");
            }
        }
        return "UTF-8";
    }
}

