/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.http;

import de.mallongigi.errorhandling.ErrorContainer;
import de.mallongigi.file.FileUtil;
import de.mallongigi.http.HttpParameters;
import de.mallongigi.podcast.model.Model;
import de.mallongigi.podcast.progress.AbstractProgressHandler;
import de.mallongigi.podcast.progress.ApplicationTask;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.OptionalLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HttpFileLoader
implements ApplicationTask {
    private static final Logger LOG = Logger.getLogger(HttpFileLoader.class.getName());
    @Inject
    private ErrorContainer errorContainer;
    private URL url;
    private Path targetFile;
    private AbstractProgressHandler<? extends Model> downloadHandler;

    public HttpFileLoader() {
        Container.inject(this);
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public void setTargetFile(Path targetFile) {
        this.targetFile = targetFile;
    }

    public void setDownloadHandler(AbstractProgressHandler<? extends Model> downloadHandler) {
        this.downloadHandler = downloadHandler;
    }

    @Override
    public void start() {
        if (!this.download(HttpClient.Version.HTTP_1_1)) {
            this.download(HttpClient.Version.HTTP_2);
        }
    }

    private boolean download(HttpClient.Version httpVersion) {
        OutputStream out = null;
        Path tempPath = null;
        try {
            if (Files.exists(this.targetFile, new LinkOption[0])) {
                return true;
            }
            LOG.info(String.format("Download %s nach %s", this.url, this.targetFile));
            HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build();
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(this.url.toURI()).header(HttpParameters.USER_AGENT.value(), "Mallongigi Podcatcher").version(httpVersion).GET().timeout(Duration.ofMinutes(3L));
            HttpRequest request = requestBuilder.build();
            HttpResponse<InputStream> response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
            if (response.statusCode() >= 400) {
                LOG.info(String.format("Download HTTP Status Error: %d", response.statusCode()));
                this.downloadHandler.setException(new Exception("Download HTTP Status Error: " + response.statusCode()));
                return false;
            }
            OptionalLong optional = response.headers().firstValueAsLong(HttpParameters.CONTENT_LENGTH.value());
            long totalDownloadSize = 10000L;
            if (optional != null && optional.isPresent()) {
                totalDownloadSize = optional.getAsLong();
            }
            tempPath = this.targetFile.resolveSibling(String.valueOf(this.targetFile.getFileName()) + FileUtil.FileType.tmp.name());
            out = Files.newOutputStream(tempPath, new OpenOption[0]);
            try (InputStream in = response.body();){
                int n;
                byte[] buffer = new byte[4096];
                long currentDownloadSize = 0L;
                while ((n = in.read(buffer)) != -1 && !this.downloadHandler.isCancelled()) {
                    out.write(buffer, 0, n);
                    this.downloadHandler.setProgressState((double)(currentDownloadSize += (long)n) / (double)totalDownloadSize);
                }
                out.flush();
                out.close();
                if (this.downloadHandler.isCancelled()) {
                    FileUtil.delete(tempPath);
                } else {
                    if (Files.exists(this.targetFile, new LinkOption[0])) {
                        this.targetFile.toFile().delete();
                    }
                    Files.move(tempPath, this.targetFile, new CopyOption[0]);
                }
            }
            return true;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, this.errorContainer.add(LanguageKeys.errorMessageDownloadFile, "URL to Call " + this.url.toString()), e);
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception noClose) {
                    LOG.log(Level.INFO, noClose.getMessage(), noClose);
                }
            }
            if (tempPath != null) {
                tempPath.toFile().delete();
            }
            this.downloadHandler.setException(e);
            return false;
        }
    }
}

