/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.file;

import de.mallongigi.file.PodcastFileExtension;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.episode.model.Chapter;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FileUtil {
    private static final Logger LOG = Logger.getLogger(FileUtil.class.getName());
    public static final String MALLONGIGI_WORKING_DIR = "mallongigi.dir";
    private static Path homeDirectory;

    private FileUtil() {
    }

    private static final void createHomeDirectory() {
        Object homeDir = System.getProperty(MALLONGIGI_WORKING_DIR);
        if (homeDir == null) {
            homeDir = System.getProperty("user.home") + File.separator + "mallongigi" + File.separator;
            System.setProperty(MALLONGIGI_WORKING_DIR, (String)homeDir);
        } else if (!((String)homeDir).endsWith(File.separator)) {
            homeDir = (String)homeDir + File.separator;
        }
        homeDirectory = FileSystems.getDefault().getPath((String)homeDir, new String[0]);
        if (Files.notExists(homeDirectory, new LinkOption[0])) {
            try {
                Files.createDirectories(homeDirectory, new FileAttribute[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static final Path getPodcastHomeDirectory() {
        if (homeDirectory == null) {
            FileUtil.createHomeDirectory();
        }
        return homeDirectory;
    }

    public static final Path getPodcastLocaleChapterDirectory(PodcastEpisodeModel episode) throws IOException {
        Path directory = FileSystems.getDefault().getPath(episode.getChannel().getLocaleDirectory(), "chapters", FileUtil.convertToLocalEncoding(episode.getId()));
        if (Files.exists(directory, new LinkOption[0])) {
            return directory;
        }
        Files.createDirectories(directory, new FileAttribute[0]);
        return directory;
    }

    public static final Path getPodcastLocaleChapterImageFile(Chapter chapter, PodcastEpisodeModel episode) throws IOException {
        Path targetFile = FileUtil.getPodcastLocaleChapterDirectory(episode).resolve(chapter.getLocalFile());
        return targetFile;
    }

    public static final Path getPodcastLocaleDownloadDirectory(PodcastChannelModel podcastChannel) throws IOException {
        Path directory = FileSystems.getDefault().getPath(podcastChannel.getLocaleDirectory(), "downloads");
        if (Files.exists(directory, new LinkOption[0])) {
            return directory;
        }
        Files.createDirectories(directory, new FileAttribute[0]);
        return directory;
    }

    public static String getFileFormat(String fileUrl) {
        if (fileUrl == null) {
            return null;
        }
        String path = null;
        try {
            path = FileUtil.getPathFromUrl(fileUrl).getFileName().toString();
            if (path == null) {
                return null;
            }
        }
        catch (Exception e) {
            path = fileUrl;
        }
        path = path.toLowerCase();
        for (String value : PodcastFileExtension.audioList) {
            if (!path.endsWith("." + value)) continue;
            return value;
        }
        for (String value : PodcastFileExtension.videoList) {
            if (!path.endsWith("." + value)) continue;
            return value;
        }
        return null;
    }

    public static final String getFileNameFromUrl(String url, String defaultFileType) {
        if (url == null || url.isBlank()) {
            return "Default_" + url.hashCode() + "." + defaultFileType;
        }
        try {
            Path file = FileUtil.getPathFromUrl(url);
            return file.getFileName().toString();
        }
        catch (Exception e) {
            return "Default_" + url.hashCode() + "." + defaultFileType;
        }
    }

    private static Path getPathFromUrl(String url) throws URISyntaxException, UnsupportedEncodingException {
        String urlProtocol = URLDecoder.decode(url, "UTF-8").toLowerCase();
        int lastProtocolPosition = Math.max(urlProtocol.lastIndexOf("https://"), urlProtocol.lastIndexOf("http://"));
        if (lastProtocolPosition > 0) {
            String sourceUrl = urlProtocol.substring(lastProtocolPosition, urlProtocol.length());
            return Paths.get(URI.create(sourceUrl).getPath(), new String[0]);
        }
        return Paths.get(new URI(url).getPath(), new String[0]);
    }

    public static final boolean delete(Path path) {
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                return true;
            }
            Files.delete(path);
            return true;
        }
        catch (IOException e) {
            LOG.log(Level.INFO, e.getMessage(), e);
            return false;
        }
    }

    public static final String convertToLocalEncoding(String value) {
        String result = value.replaceAll("\u00fc", "ue");
        result = result.replaceAll("\u00f6", "oe");
        result = result.replaceAll("\u00e4", "ae");
        result = result.replaceAll("\u00df", "ss");
        result = result.replaceAll("\\W", "_");
        return result;
    }

    public static enum FileType {
        zip,
        txt,
        tmp,
        properties,
        none;

    }
}

