/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.file;

import de.mallongigi.file.FileUtil;
import de.mallongigi.file.PodcastFilenameConverter;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.podcast.progress.ApplicationTask;
import de.mallongigi.podcast.progress.EpisodeCopyHandler;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;

public final class FileCopyToUsbPath
implements ApplicationTask {
    private Logger LOG = Logger.getLogger(FileCopyToUsbPath.class.getName());
    @Inject
    private ApplicationSettings settings;
    private final EpisodeCopyHandler handler;

    public FileCopyToUsbPath(EpisodeCopyHandler handler) {
        this.handler = handler;
        Container.inject(this);
    }

    public boolean targetFileExists() throws Exception {
        return Files.exists(this.getTargetFile(), new LinkOption[0]);
    }

    @Override
    public void start() {
        try {
            Path original = this.getOrginalFile();
            Path copy = this.getTargetFile();
            if (Files.exists(copy, new LinkOption[0])) {
                return;
            }
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(original, new OpenOption[0]));
                 BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(copy, new OpenOption[0]));){
                int lengthRead;
                byte[] buffer = new byte[1024];
                long progress = 0L;
                while ((lengthRead = ((InputStream)in).read(buffer)) > 0 && !this.handler.isCancelled()) {
                    ((OutputStream)out).write(buffer, 0, lengthRead);
                    ((OutputStream)out).flush();
                    this.handler.setProgressState((double)(progress += (long)lengthRead) / (double)Files.size(original));
                }
            }
            if (this.handler.isCancelled()) {
                FileUtil.delete(copy);
            }
        }
        catch (Exception e) {
            try {
                if (this.getTargetFile() != null) {
                    FileUtil.delete(this.getTargetFile());
                }
            }
            catch (Exception ex) {
                this.LOG.info(ex.getMessage());
            }
            this.handler.getProgressModel().setErrorMessage(LanguageKeys.errorCopyFile);
            this.handler.getProgressModel().setErrorMessageDetails(e);
        }
    }

    private String getUsbPath() {
        PodcastEpisodeModel model = (PodcastEpisodeModel)this.handler.getProgressModel().getModel();
        String result = model.getChannel().getUsbPath();
        if (result != null && result.length() > 0) {
            return result;
        }
        result = this.settings.getUsbStickPathProperty().getValue();
        return result;
    }

    private Path getTargetFile() throws Exception {
        PodcastEpisodeModel episode = (PodcastEpisodeModel)this.handler.getProgressModel().getModel();
        Path original = this.getOrginalFile();
        String usbPathString = this.getUsbPath();
        if (this.handler.createAlias()) {
            return Paths.get(usbPathString + File.separator + new PodcastFilenameConverter().getAlias(episode), new String[0]);
        }
        return Paths.get(usbPathString + File.separator + String.valueOf(original.getFileName()), new String[0]);
    }

    private Path getOrginalFile() throws Exception {
        PodcastEpisodeModel episode = (PodcastEpisodeModel)this.handler.getProgressModel().getModel();
        Path original = episode.getChannel().getPodcastFilenameConverter().convertEpisode(episode);
        Path clearMP3File = new PodcastFilenameConverter().convertToClearMP3Filename(episode);
        if (Files.exists(clearMP3File, new LinkOption[0])) {
            original = clearMP3File;
        } else {
            Path mp3File = episode.getChannel().getPodcastFilenameConverter().convertToMP3File(episode);
            if (Files.exists(mp3File, new LinkOption[0])) {
                original = mp3File;
            }
        }
        return original;
    }
}

