/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.file;

import de.mallongigi.file.FileUtil;
import de.mallongigi.file.PodcastFilenameConverter;
import de.mallongigi.images.model.ImageModel;
import de.mallongigi.platform.OSPlatform;
import de.mallongigi.podcast.channel.model.PodcastChannelContainer;
import de.mallongigi.podcast.channel.model.PodcastNavigationViewType;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.podcast.progress.ApplicationTask;
import de.mallongigi.podcast.progress.ClearChannelDataHandler;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Logger;

public final class ClearChannelDatas
implements ApplicationTask {
    private static final Logger LOG = Logger.getLogger(ClearChannelDatas.class.getName());
    @Inject
    private PodcastChannelContainer podcastChannelContainer;
    @Inject
    private OSPlatform plattform;
    private boolean cancel = false;
    private final ClearChannelDataHandler handler;

    public ClearChannelDatas(ClearChannelDataHandler handler) {
        this.handler = handler;
        Container.inject(this);
    }

    @Override
    public void start() {
        this.clearOldTempFiles();
        this.handler.setProgressState(0.33);
        this.clearOldImageDatas();
        this.handler.setProgressState(0.66);
        this.clearOldLogFiles();
        this.handler.setProgressState(1.0);
    }

    private void clearOldTempFiles() {
        List<PodcastChannelModel> channelList = this.podcastChannelContainer.getPodcastChannels(PodcastNavigationViewType.Podcast);
        PodcastFilenameConverter fileNameConverter = new PodcastFilenameConverter();
        for (PodcastChannelModel channel : channelList) {
            Path path = Paths.get(channel.getLocaleDirectory(), new String[0]);
            if (Files.notExists(path, new LinkOption[0]) || this.cancel) continue;
            List<PodcastEpisodeModel> episodeList = channel.getEpisodes();
            for (PodcastEpisodeModel episode : episodeList) {
                if (this.cancel) continue;
                try {
                    Path file = fileNameConverter.convertEpisode(episode);
                    Path tempPath = file.resolveSibling(String.valueOf(file.getFileName()) + FileUtil.FileType.tmp.name());
                    if (!FileUtil.delete(tempPath)) continue;
                    LOG.info(String.format("Delete Temp File: %s", tempPath.toAbsolutePath()));
                }
                catch (IOException e) {
                    LOG.info("Cant delete old Temp Files");
                }
            }
        }
    }

    private void clearOldLogFiles() {
        try {
            Calendar calendar = this.plattform.getCalendar();
            calendar.set(2, calendar.get(2) - 1);
            Files.list(FileUtil.getPodcastHomeDirectory()).forEach(f -> {
                try {
                    if (!f.toString().endsWith("log.txt.lck") || this.cancel) {
                        return;
                    }
                    if (calendar.getTimeInMillis() < Files.getLastModifiedTime(f, new LinkOption[0]).toMillis()) {
                        return;
                    }
                    Files.deleteIfExists(f);
                    LOG.info(String.format("Mark Log File to delete: %s", f.toString()));
                }
                catch (Exception e) {
                    LOG.info(e.getMessage());
                }
            });
        }
        catch (IOException e) {
            LOG.info(e.getMessage());
        }
    }

    private void clearOldImageDatas() {
        try {
            Calendar calendar = this.plattform.getCalendar();
            calendar.set(2, calendar.get(2) - 6);
            List<PodcastChannelModel> channelList = this.podcastChannelContainer.getPodcastChannels(PodcastNavigationViewType.Podcast);
            for (PodcastChannelModel channel : channelList) {
                Path channelDirectory = Paths.get(channel.getLocaleDirectory(), new String[0]);
                if (Files.notExists(channelDirectory, new LinkOption[0]) || this.cancel || Files.list(channelDirectory).count() < 10L) continue;
                ImageModel channelImage = channel.getImage();
                Path channelLocation = null;
                if (channelImage != null) {
                    channelLocation = Paths.get(channelImage.getLocation(), new String[0]);
                }
                List<PodcastEpisodeModel> episodeList = channel.getEpisodes();
                for (PodcastEpisodeModel episode : episodeList) {
                    Path imageFile;
                    ImageModel imageModel;
                    if (calendar.getTimeInMillis() < episode.getDate().getTime() || episode.isCurrentDownload() || episode.getState().isPresent() || (imageModel = episode.getImage()) == null || Files.isDirectory(imageFile = Paths.get(imageModel.getLocation(), new String[0]), new LinkOption[0]) || channelLocation != null && imageFile.equals(channelLocation) || !Files.exists(imageFile, new LinkOption[0])) continue;
                    Files.deleteIfExists(imageFile);
                    LOG.info(String.format("Mark Image File to delete: %s", imageFile));
                }
            }
        }
        catch (IOException e) {
            LOG.info(e.getMessage());
        }
    }

    public void cancel() {
        this.cancel = true;
    }
}

