/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.ffmpeg;

import de.mallongigi.ffmpeg.FFMPEGCommand;
import de.mallongigi.ffmpeg.FFMPEGExecute;
import de.mallongigi.ffmpeg.FFMPEGTools;
import de.mallongigi.podcast.progress.AbstractOpenDirectoryHandler;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FFMPEGExecuteFactory {
    private static final Logger LOG = Logger.getLogger(FFMPEGExecuteFactory.class.getName());

    FFMPEGExecuteFactory() {
    }

    FFMPEGExecute create() throws Exception {
        char version = this.getVersion(new FFMPEGCommand(FFMPEGTools.ffmpeg).add("-version"));
        final DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, true).optionalEnd().toFormatter();
        switch (version) {
            case '6': {
                return new FFMPEGExecute(){

                    @Override
                    public void execute(FFMPEGCommand command, Process process, AbstractOpenDirectoryHandler handler) throws Exception {
                        String line;
                        ProcessBuilder builder = new ProcessBuilder(command.build());
                        builder.redirectErrorStream(true);
                        process = builder.start();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        long totalProgressDuration = 0L;
                        while ((line = reader.readLine()) != null) {
                            line = line.trim();
                            LOG.info(line);
                            try {
                                int start;
                                LocalTime t;
                                String duration;
                                int end;
                                if (line.startsWith("Duration:")) {
                                    int start2 = line.indexOf(":") + 2;
                                    end = line.indexOf(",");
                                    duration = line.substring(start2, end);
                                    t = LocalTime.parse(duration, formatter);
                                    totalProgressDuration = t.get(ChronoField.MILLI_OF_DAY);
                                    continue;
                                }
                                if (!line.startsWith("size") && !line.startsWith("frame=") || (end = line.indexOf(".", start = line.indexOf("time=") + 5)) == -1 || end <= start) continue;
                                duration = line.substring(start, end);
                                t = LocalTime.parse(duration);
                                handler.setProgressState((double)t.get(ChronoField.MILLI_OF_DAY) / (double)totalProgressDuration);
                            }
                            catch (Exception e) {
                                LOG.severe(e.getMessage());
                            }
                        }
                    }
                };
            }
        }
        return new FFMPEGExecute(){

            @Override
            public void execute(FFMPEGCommand command, Process process, AbstractOpenDirectoryHandler handler) throws Exception {
                String line;
                ProcessBuilder builder = new ProcessBuilder(command.build());
                builder.redirectErrorStream(true);
                process = builder.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                long totalProgressDuration = 0L;
                double progressTime = 0.0;
                while ((line = reader.readLine()) != null) {
                    line = line.trim();
                    LOG.info(line);
                    try {
                        if (line.startsWith("Duration:")) {
                            int start = line.indexOf(":") + 2;
                            int end = line.indexOf(",");
                            String duration = line.substring(start, end);
                            LocalTime t = LocalTime.parse(duration, formatter);
                            totalProgressDuration = t.get(ChronoField.MILLI_OF_DAY);
                            continue;
                        }
                        int start = line.indexOf("elapsed=");
                        if (start == -1) continue;
                        String duration = line.substring(start + 8, line.length());
                        LocalTime t = LocalTime.parse(duration, formatter);
                        if ((progressTime += (double)t.get(ChronoField.MILLI_OF_DAY)) > (double)totalProgressDuration) {
                            progressTime = totalProgressDuration;
                        }
                        handler.setProgressState(progressTime / (double)totalProgressDuration);
                    }
                    catch (Exception e) {
                        LOG.severe(e.getMessage());
                    }
                }
            }
        };
    }

    private char getVersion(FFMPEGCommand command) throws Exception {
        String line;
        ProcessBuilder builder = new ProcessBuilder(command.build());
        builder.redirectErrorStream(true);
        Process process = builder.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String result = null;
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            LOG.info(line);
            int pos = line.indexOf("ffmpeg version");
            if (pos == -1) continue;
            try {
                result = line.substring(pos + 14, line.indexOf(" ", pos + 15));
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Cant find ffmpeg Version Number", e);
            }
        }
        return result.charAt(1);
    }
}

