/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.ffmpeg;

import de.mallongigi.ffmpeg.FFMPEGTools;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

final class FFMPEGCommand {
    @Inject
    private ApplicationSettings settings;
    private List<String> parameters = new ArrayList<String>();

    FFMPEGCommand(FFMPEGTools tool) {
        Container.inject(this);
        this.init(tool);
    }

    boolean isFFMPEGAvailable() {
        String ffprobe = this.settings.getConverterPathProperty().getValue();
        if (ffprobe == null || ffprobe.length() == 0) {
            return false;
        }
        return new File(ffprobe).exists();
    }

    private void init(FFMPEGTools tool) {
        switch (tool) {
            case ffmpeg: {
                this.parameters.add(this.settings.getConverterPathProperty().getValue());
                break;
            }
            case ffprobe: {
                Object path = this.settings.getConverterPathProperty().getValue();
                String toReplace = "ffmpeg";
                String replacement = "ffprobe";
                int lastIndex = ((String)path).lastIndexOf(toReplace);
                if (lastIndex == -1) break;
                path = ((String)path).substring(0, lastIndex) + replacement + ((String)path).substring(lastIndex + toReplace.length());
                this.add(new String[]{path});
            }
        }
    }

    FFMPEGCommand add(String ... parameter) {
        for (String p : parameter) {
            this.parameters.add(p);
        }
        return this;
    }

    FFMPEGCommand add(Path file) {
        this.add(file.toString());
        return this;
    }

    FFMPEGCommand add(File file) {
        this.add(file.toPath());
        return this;
    }

    List<String> build() {
        return this.parameters;
    }
}

