/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.dialog;

import de.mallongigi.errorhandling.ErrorContainer;
import de.mallongigi.platform.OSPlatform;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.resource.language.LanguageResource;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.start.PreLoaderWindow;
import de.mallongigi.ui.concurrent.JavaFXUtil;
import de.mallongigi.ui.elements.UILabel;
import de.mallongigi.ui.style.Styles;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Dialog;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;

public final class ErrorDialog {
    private static final Logger LOG = Logger.getLogger(PreLoaderWindow.class.getName());
    @Inject
    private ErrorContainer errorContainer;
    @Inject(safety=false)
    private ReentrantLock lock;
    @Inject
    private OSPlatform osPlatform;
    @Inject
    private Styles styles;
    @Inject
    private LanguageResource languageResource;

    public ErrorDialog() {
        Container.inject(this);
    }

    private void show(String message, Throwable exception) {
        LOG.log(Level.INFO, message, exception);
        Alert alert = new Alert(Alert.AlertType.ERROR);
        this.styles.setStyle(alert.getDialogPane());
        this.styles.setWindowIcon(alert.getDialogPane(), DefaultIcons.Error);
        alert.setTitle(this.languageResource.messageForKey(LanguageKeys.exceptionDialog));
        alert.setHeaderText(message);
        String exceptionText = "No Details";
        if (exception != null) {
            alert.setContentText(exception.getMessage());
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            exception.printStackTrace(pw);
            exceptionText = sw.toString();
        }
        UILabel label = new UILabel(LanguageKeys.exceptionStack);
        TextArea textArea = new TextArea(exceptionText);
        textArea.setEditable(false);
        textArea.setWrapText(true);
        textArea.setMaxWidth(Double.MAX_VALUE);
        textArea.setMaxHeight(Double.MAX_VALUE);
        GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane expContent = new GridPane();
        expContent.setMaxWidth(Double.MAX_VALUE);
        expContent.add((Node)label, 0, 0);
        expContent.add((Node)textArea, 0, 1);
        alert.getDialogPane().setExpandableContent((Node)expContent);
        this.osPlatform.setDarkMode((Dialog<?>)alert);
        alert.showAndWait();
    }

    public void showErrorContainer() {
        this.show(this.errorContainer.toString(), null);
        this.errorContainer.clear();
    }

    public void show(LanguageKeys key, Throwable exception) {
        this.show(this.languageResource.messageForKey(key), exception);
    }

    public void show(final LanguageKeys key, final Exception exception, final Object ... parameters) {
        JavaFXUtil.optionalRunLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ErrorDialog.this.lock.lock();
                    ErrorDialog.this.show(ErrorDialog.this.languageResource.messageForKey(key, parameters), (Throwable)exception);
                }
                finally {
                    ErrorDialog.this.lock.unlock();
                }
            }
        });
    }
}

